/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.builder.tree;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.misc.DelimitedBuilder;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.builder.BasedSegmentBuilder;
import icyllis.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import icyllis.flexmark.util.sequence.builder.Seg;
import icyllis.flexmark.util.sequence.builder.tree.Segment;
import icyllis.flexmark.util.sequence.builder.tree.SegmentTree;
import icyllis.flexmark.util.sequence.builder.tree.SegmentTreePos;
import icyllis.flexmark.util.sequence.builder.tree.SegmentTreeRange;

public class SegmentOffsetTree
extends SegmentTree {
    @NotNull
    protected final int[] startIndices;

    protected SegmentOffsetTree(@NotNull int[] treeData, @NotNull byte[] segmentBytes, @NotNull int[] startIndices) {
        super(treeData, segmentBytes);
        this.startIndices = startIndices;
    }

    @NotNull
    public static SegmentOffsetTree build(@NotNull Iterable<Seg> segments, @NotNull CharSequence allText) {
        SegmentTree.SegmentTreeData segmentTreeData = SegmentOffsetTree.buildTreeData(segments, allText, false);
        assert (segmentTreeData.startIndices != null);
        return new SegmentOffsetTree(segmentTreeData.treeData, segmentTreeData.segmentBytes, segmentTreeData.startIndices);
    }

    @NotNull
    public static SegmentOffsetTree build(@NotNull BasedSegmentBuilder builder) {
        @NotNull SegmentTree.SegmentTreeData segmentTreeData = SegmentOffsetTree.buildTreeData(builder.getSegments(), builder.getText(), true);
        return new SegmentTree(segmentTreeData.treeData, segmentTreeData.segmentBytes).getSegmentOffsetTree(builder.getBaseSequence());
    }

    @NotNull
    public static SegmentOffsetTree build(@NotNull BasedSequence baseSeq) {
        return baseSeq.getSegmentTree().getSegmentOffsetTree(baseSeq);
    }

    public int endOffset(int pos) {
        return super.aggrLength(pos);
    }

    public int getStartIndex(int pos) {
        return pos < 0 ? 0 : (pos >= this.startIndices.length ? this.startIndices[this.startIndices.length - 1] : this.startIndices[pos]);
    }

    @Override
    @NotNull
    public Segment getSegment(int pos, @NotNull BasedSequence baseSeq) {
        return Segment.getSegment(this.segmentBytes, this.byteOffset(pos), pos, this.startIndices[pos], baseSeq);
    }

    @Nullable
    public SegmentTreePos findSegmentPosByOffset(int offset) {
        return SegmentOffsetTree.findSegmentPos(offset, this.treeData, 0, this.size());
    }

    @Nullable
    public Segment getPreviousText(@NotNull Segment segment, @NotNull BasedSequence baseSeq) {
        if (segment.getPos() == 0) {
            Segment textSeg;
            if (segment.getStartIndex() > 0 && (textSeg = this.getSegment(0, -1, 0, baseSeq)).isText()) {
                return textSeg;
            }
        } else {
            Segment prevSegment = this.getSegment(segment.getPos() - 1, baseSeq);
            return this.getNextText(prevSegment, baseSeq);
        }
        return null;
    }

    @Nullable
    public Segment getNextText(@NotNull Segment segment, @NotNull BasedSequence baseSeq) {
        Segment textSeg;
        if (segment.getByteOffset() + segment.getByteLength() < this.segmentBytes.length && (textSeg = this.getSegment(segment.getByteOffset() + segment.getByteLength(), -1, segment.getEndIndex(), baseSeq)).isText()) {
            return textSeg;
        }
        return null;
    }

    @Nullable
    public Segment findSegmentByOffset(int offset, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        int startPos = 0;
        int endPos = this.size();
        SegmentTreePos treePos = super.findSegmentPos(offset, startPos, endPos);
        if (treePos != null) {
            return Segment.getSegment(this.segmentBytes, this.byteOffset(treePos.pos), treePos.pos, this.startIndices[treePos.pos], baseSeq);
        }
        return null;
    }

    @Override
    @NotNull
    public String toString(@NotNull BasedSequence baseSeq) {
        Segment segment;
        DelimitedBuilder out = new DelimitedBuilder(", ");
        out.append(this.getClass().getSimpleName()).append("{aggr: {");
        int iMax = this.size();
        for (int i = 0; i < iMax; ++i) {
            out.append("[").append(this.aggrLength(i)).append(", ").append(this.byteOffset(i)).append(":");
            out.append(", :").append(this.startIndices[i]);
            out.append("]").mark();
        }
        out.unmark().append(" }, seg: { ");
        for (int offset = 0; offset < this.segmentBytes.length; offset += segment.getByteLength()) {
            segment = Segment.getSegment(this.segmentBytes, offset, 0, 0, baseSeq);
            out.append(offset).append(":").append(segment).mark();
        }
        out.unmark().append(" } }");
        return out.toString();
    }

    @Override
    @Deprecated
    public boolean hasPreviousAnchor(int pos) {
        return false;
    }

    @Override
    @Deprecated
    public int previousAnchorOffset(int pos) {
        return 0;
    }

    @Override
    @Deprecated
    public int aggrLength(int pos) {
        return super.aggrLength(pos);
    }

    @Override
    @Deprecated
    @Nullable
    public SegmentTreePos findSegmentPos(int index) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    @Nullable
    public Segment findSegment(int index, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    @Nullable
    public Segment findSegment(int index, int startPos, int endPos, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    @NotNull
    public SegmentTreeRange getSegmentRange(int startIndex, int endIndex, int startPos, int endPos, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        return super.getSegmentRange(startIndex, endIndex, startPos, endPos, baseSeq, hint);
    }

    @Override
    @Deprecated
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder, @NotNull SegmentTreeRange treeRange) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder, int startIndex, int endIndex, int startOffset, int endOffset, int startPos, int endPos) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    @Nullable
    public SegmentTreePos findSegmentPos(int index, int startPos, int endPos) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }

    @Override
    @Deprecated
    @Nullable
    public Segment getPrevAnchor(int pos, @NotNull BasedSequence baseSeq) {
        throw new IllegalStateException("Method in SegmentOffsetTree should not be used");
    }
}

